/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.registry.common.util;

import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.dubbo.registry.common.domain.LoadBalance;
import com.alibaba.dubbo.registry.common.domain.Override;
import com.alibaba.dubbo.registry.common.domain.Weight;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class OverrideUtils {
    public static List<Weight> overridesToWeights(List<Override> overrides) {
        ArrayList<Weight> weights = new ArrayList<Weight>();
        if (overrides == null) {
            return weights;
        }
        for (Override o : overrides) {
            if (StringUtils.isEmpty((String)o.getParams())) continue;
            Map params = StringUtils.parseQueryString((String)o.getParams());
            for (Map.Entry entry : params.entrySet()) {
                if (!((String)entry.getKey()).equals("weight")) continue;
                Weight weight = new Weight();
                weight.setAddress(o.getAddress());
                weight.setId(o.getId());
                weight.setService(o.getService());
                weight.setWeight(Integer.valueOf((String)entry.getValue()).intValue());
                weights.add(weight);
            }
        }
        return weights;
    }

    public static Weight overrideToWeight(Override override) {
        return (Weight)OverrideUtils.overridesToWeights(Arrays.asList(override)).get(0);
    }

    public static Override weightToOverride(Weight weight) {
        Override override = new Override();
        override.setId(weight.getId());
        override.setAddress(weight.getAddress());
        override.setEnabled(true);
        override.setParams("weight=" + weight.getWeight());
        override.setService(weight.getService());
        return override;
    }

    public static List<LoadBalance> overridesToLoadBalances(List<Override> overrides) {
        ArrayList<LoadBalance> loadBalances = new ArrayList<LoadBalance>();
        if (overrides == null) {
            return loadBalances;
        }
        for (Override o : overrides) {
            if (StringUtils.isEmpty((String)o.getParams())) continue;
            Map params = StringUtils.parseQueryString((String)o.getParams());
            for (Map.Entry entry : params.entrySet()) {
                if (!((String)entry.getKey()).endsWith("loadbalance")) continue;
                LoadBalance loadBalance = new LoadBalance();
                String method = null;
                method = ((String)entry.getKey()).endsWith(".loadbalance") ? ((String)entry.getKey()).split(".loadbalance")[0] : "*";
                loadBalance.setMethod(method);
                loadBalance.setId(o.getId());
                loadBalance.setService(o.getService());
                loadBalance.setStrategy((String)entry.getValue());
                loadBalances.add(loadBalance);
            }
        }
        return loadBalances;
    }

    public static LoadBalance overrideToLoadBalance(Override override) {
        return (LoadBalance)OverrideUtils.overridesToLoadBalances(Arrays.asList(override)).get(0);
    }

    public static Override loadBalanceToOverride(LoadBalance loadBalance) {
        Override override = new Override();
        override.setId(loadBalance.getId());
        override.setService(loadBalance.getService());
        override.setEnabled(true);
        String method = loadBalance.getMethod();
        String strategy = loadBalance.getStrategy();
        if (StringUtils.isEmpty((String)method) || method.equals("*")) {
            override.setParams("loadbalance=" + strategy);
        } else {
            override.setParams(method + ".loadbalance=" + strategy);
        }
        return override;
    }
}

