/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.registry.common.route;

import com.alibaba.dubbo.registry.common.domain.Consumer;
import com.alibaba.dubbo.registry.common.domain.Override;
import com.alibaba.dubbo.registry.common.domain.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OverrideUtils {
    public static final Comparator<Override> OVERRIDE_COMPARATOR = new /* Unavailable Anonymous Inner Class!! */;

    public static void setConsumerOverrides(Consumer consumer, List<Override> overrides) {
        if (consumer == null || overrides == null) {
            return;
        }
        ArrayList<Override> result = new ArrayList<Override>(overrides.size());
        for (Override override : overrides) {
            if (!override.isEnabled()) continue;
            if (override.isMatch(consumer)) {
                result.add(override);
            }
            if (!override.isUniqueMatch(consumer)) continue;
            consumer.setOverride(override);
        }
        Collections.sort(result, OVERRIDE_COMPARATOR);
        consumer.setOverrides(result);
    }

    public static void setProviderOverrides(Provider provider, List<Override> overrides) {
        if (provider == null || overrides == null) {
            return;
        }
        ArrayList<Override> result = new ArrayList<Override>(overrides.size());
        for (Override override : overrides) {
            if (!override.isEnabled()) continue;
            if (override.isMatch(provider)) {
                result.add(override);
            }
            if (!override.isUniqueMatch(provider)) continue;
            provider.setOverride(override);
        }
        provider.setOverrides(overrides);
    }
}

