/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.registry.common.registry;

import com.alibaba.dubbo.common.utils.StringUtils;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertUtil {
    private ConvertUtil() {
    }

    public static Map<String, Map<String, String>> convertRegister(Map<String, Map<String, String>> register) {
        HashMap<String, Map<String, String>> newRegister = new HashMap<String, Map<String, String>>();
        for (Map.Entry<String, Map<String, String>> entry : register.entrySet()) {
            String serviceName = entry.getKey();
            Map<String, String> serviceUrls = entry.getValue();
            if (!serviceName.contains(":") && !serviceName.contains("/")) {
                for (Map.Entry<String, String> entry2 : serviceUrls.entrySet()) {
                    HashMap<String, String> newUrls;
                    String serviceUrl = entry2.getKey();
                    String serviceQuery = entry2.getValue();
                    Map params = StringUtils.parseQueryString((String)serviceQuery);
                    String group = (String)params.get("group");
                    String version = (String)params.get("version");
                    params.remove("group");
                    params.remove("version");
                    String name = serviceName;
                    if (group != null && group.length() > 0) {
                        name = group + "/" + name;
                    }
                    if (version != null && version.length() > 0 && !"0.0.0".equals(version)) {
                        name = name + ":" + version;
                    }
                    if ((newUrls = (HashMap<String, String>)newRegister.get(name)) == null) {
                        newUrls = new HashMap<String, String>();
                        newRegister.put(name, newUrls);
                    }
                    newUrls.put(serviceUrl, StringUtils.toQueryString((Map)params));
                }
                continue;
            }
            newRegister.put(serviceName, serviceUrls);
        }
        return newRegister;
    }

    public static Map<String, String> convertSubscribe(Map<String, String> subscribe) {
        HashMap<String, String> newSubscribe = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : subscribe.entrySet()) {
            String serviceName = entry.getKey();
            String serviceQuery = entry.getValue();
            if (!serviceName.contains(":") && !serviceName.contains("/")) {
                Map params = StringUtils.parseQueryString((String)serviceQuery);
                String group = (String)params.get("group");
                String version = (String)params.get("version");
                params.remove("group");
                params.remove("version");
                String name = serviceName;
                if (group != null && group.length() > 0) {
                    name = group + "/" + name;
                }
                if (version != null && version.length() > 0 && !"0.0.0".equals(version)) {
                    name = name + ":" + version;
                }
                newSubscribe.put(name, StringUtils.toQueryString((Map)params));
                continue;
            }
            newSubscribe.put(serviceName, serviceQuery);
        }
        return newSubscribe;
    }

    public static Map<String, String> serviceName2Map(String serviceName) {
        String group = null;
        String version = null;
        int i = serviceName.indexOf("/");
        if (i > 0) {
            group = serviceName.substring(0, i);
            serviceName = serviceName.substring(i + 1);
        }
        if ((i = serviceName.lastIndexOf(":")) > 0) {
            version = serviceName.substring(i + 1);
            serviceName = serviceName.substring(0, i);
        }
        HashMap<String, String> ret = new HashMap<String, String>();
        if (!StringUtils.isEmpty((String)serviceName)) {
            ret.put("interface", serviceName);
        }
        if (!StringUtils.isEmpty((String)version)) {
            ret.put("version", version);
        }
        if (!StringUtils.isEmpty((String)group)) {
            ret.put("group", group);
        }
        return ret;
    }
}

