/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.governance.web.util;

import java.io.Serializable;

public class Paginator
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 3688506614705500726L;
    int itemsPerPage = 10;
    int sliderSize = 7;
    int currentPage;
    String path;
    int totalItems;
    int totalPage;

    public Paginator(int currentPage, int totalItems, String path) {
        this.initPagination(currentPage, totalItems, 0, 0, path);
    }

    public Paginator(String currentPage, int totalItems, String path) {
        int currentPageTemp = 1;
        if (currentPage != null && !currentPage.equals("")) {
            currentPageTemp = Integer.parseInt(currentPage);
        }
        this.initPagination(currentPageTemp, totalItems, 0, 0, path);
    }

    public void initPagination(int currentPageT, int totalItemsT, int sliderSizeT, int itemsPerPageT, String path) {
        this.totalItems = totalItemsT > 0 ? totalItemsT : 0;
        this.sliderSize = sliderSizeT > 0 ? sliderSizeT : this.sliderSize;
        this.itemsPerPage = itemsPerPageT > 0 ? itemsPerPageT : this.itemsPerPage;
        this.totalPage = this.totalItems / this.itemsPerPage + (this.totalItems % this.itemsPerPage == 0 ? 0 : 1);
        this.currentPage = currentPageT > 0 ? currentPageT : 1;
        this.currentPage = this.currentPage < this.totalPage ? this.currentPage : this.totalPage;
        this.currentPage = this.currentPage == 0 ? 1 : this.currentPage;
        this.path = path;
    }

    public int getItemsPerPage() {
        return this.itemsPerPage;
    }

    public int[] getSlider() {
        int width = this.sliderSize;
        if (this.totalItems < 1) {
            return new int[0];
        }
        if (width > this.totalPage) {
            width = this.totalPage;
        }
        int[] slider = new int[width];
        int startPage = this.currentPage - (width - 1) / 2;
        if (startPage < 1) {
            startPage = 1;
        }
        if (startPage + width - 1 > this.totalPage) {
            startPage = this.totalPage - width + 1;
        }
        for (int i = 0; i < width; ++i) {
            slider[i] = startPage + i;
        }
        return slider;
    }

    public String getPaginatorBar() {
        int i;
        StringBuffer str = new StringBuffer("<div class=\"page\">");
        str.append("<script type=\"text/javascript\">function gotoPage(page){window.location.href=\"/" + this.path + "/pages/\" + page;}</script>");
        str.append("total items: " + this.totalItems + "&nbsp;&nbsp;");
        str.append("page " + this.currentPage + " of " + this.totalPage + "nbsp;&nbsp;");
        if (this.currentPage > 1) {
            str.append("<a class=\"prev\" href=\"#\" onclick=\"gotoPage(1);\">Home</a>");
            str.append("<a class=\"prev\" href=\"#\" onclick=\"gotoPage(" + (this.currentPage - 1) + ");\">Previous</a>");
        } else {
            str.append("<a class=\"prev\" href=\"#\">Home</a>");
            str.append("<a class=\"prev\" href=\"#\">Previous</a>");
        }
        int[] slider = this.getSlider();
        for (i = 0; i < slider.length; ++i) {
            if (slider[i] == this.currentPage) {
                str.append("<a class=\"num current_num\" href=\"#\">");
            } else {
                str.append("<a class=\"num\" href=\"#\" onclick=\"gotoPage(" + slider[i] + ");\">");
            }
            str.append(slider[i] + "</a>");
        }
        if (this.currentPage < this.totalPage) {
            str.append("<a class=\"prev\" href=\"#\" onclick=\"gotoPage(" + (this.currentPage + 1) + ");\">");
        } else {
            str.append("<a class=\"prev\" href=\"#\">");
        }
        str.append("Next</a>&nbsp;&nbsp;");
        str.append("jump to page ");
        str.append("<SELECT size=1 onchange=\"gotoPage(this.value);\">");
        for (i = 1; i < this.totalPage + 1; ++i) {
            if (i == this.currentPage) {
                str.append("<OPTION value=" + i + " selected>" + i + "</OPTION>");
                continue;
            }
            str.append("<OPTION value=" + i + ">" + i + "</OPTION>");
        }
        str.append("</SELECT>");
        str.append("</div>");
        return str.toString();
    }

    public int getStartIndex() {
        return (this.currentPage - 1) * this.itemsPerPage + 1;
    }
}

