/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.governance.web.sysmanage.module.screen;

import com.alibaba.dubbo.governance.service.ConfigService;
import com.alibaba.dubbo.governance.web.common.module.screen.Restful;
import com.alibaba.dubbo.registry.common.domain.Config;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configs
extends Restful {
    @Autowired
    private ConfigService configDAO;
    @Autowired
    private HttpServletRequest request;

    public void index(Map<String, Object> context) {
        context.put("configs", this.configDAO.findAllConfigsMap());
    }

    public boolean update(Map<String, Object> context) {
        Map all = this.request.getParameterMap();
        if (all != null && all.size() > 0) {
            if (!"R".equals(this.currentUser.getRole())) {
                context.put("message", this.getMessage("HaveNoRootPrivilege", new Object[0]));
                return false;
            }
            ArrayList<Config> configs = new ArrayList<Config>();
            for (Map.Entry entry : all.entrySet()) {
                String key = (String)entry.getKey();
                String[] values = (String[])entry.getValue();
                if (key == null || key.length() <= 0 || key.startsWith("_")) continue;
                String value = "";
                if (values != null && values.length > 0 && values[0] != null && values[0].length() > 0) {
                    value = values[0];
                }
                Config config = new Config();
                config.setKey(key);
                config.setUsername(this.currentUser.getUsername());
                config.setOperatorAddress((String)context.get("operatorAddress"));
                config.setValue(value);
                configs.add(config);
            }
            if (configs.size() > 0) {
                this.configDAO.update(configs);
                HashSet<String> usernames = new HashSet<String>();
                usernames.add(this.currentUser.getName());
                HashMap<String, ArrayList<Config>> params = new HashMap<String, ArrayList<Config>>();
                params.put("configs", configs);
            }
            return true;
        }
        context.put("message", this.getMessage("MissRequestParameters", new Object[]{"configKey,configValue"}));
        return false;
    }
}

