/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.governance.web.governance.module.screen;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.alibaba.dubbo.governance.service.OverrideService;
import com.alibaba.dubbo.governance.service.ProviderService;
import com.alibaba.dubbo.governance.web.common.module.screen.Restful;
import com.alibaba.dubbo.registry.common.domain.Override;
import com.alibaba.dubbo.registry.common.domain.Provider;
import com.alibaba.dubbo.registry.common.domain.Weight;
import com.alibaba.dubbo.registry.common.util.OverrideUtils;
import com.alibaba.dubbo.registry.common.util.Tool;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Weights
extends Restful {
    private static final Pattern IP_PATTERN = Pattern.compile("\\d{1,3}(\\.\\d{1,3}){3}$");
    private static final Pattern LOCAL_IP_PATTERN = Pattern.compile("127(\\.\\d{1,3}){3}$");
    private static final Pattern ALL_IP_PATTERN = Pattern.compile("0{1,3}(\\.0{1,3}){3}$");
    @Autowired
    private OverrideService overrideService;
    @Autowired
    private ProviderService providerService;

    public void index(Map<String, Object> context) {
        String service = StringUtils.trimToNull((String)((String)context.get("service")));
        String address = (String)context.get("address");
        address = Tool.getIP((String)address);
        List weights = service != null && service.length() > 0 ? OverrideUtils.overridesToWeights((List)this.overrideService.findByService(service)) : (address != null && address.length() > 0 ? OverrideUtils.overridesToWeights((List)this.overrideService.findByAddress(address)) : OverrideUtils.overridesToWeights((List)this.overrideService.findAll()));
        context.put("weights", weights);
    }

    public void add(Map<String, Object> context) {
        String service = (String)context.get("service");
        if (service != null && service.length() > 0 && !service.contains("*")) {
            List providerList = this.providerService.findByService(service);
            ArrayList<String> addressList = new ArrayList<String>();
            for (Provider provider : providerList) {
                addressList.add(provider.getUrl().split("://")[1].split("/")[0]);
            }
            context.put("addressList", addressList);
            context.put("service", service);
            context.put("methods", CollectionUtils.sort((List)this.providerService.findMethodsByService(service)));
        } else {
            List serviceList = Tool.sortSimpleName((List)this.providerService.findServices());
            context.put("serviceList", serviceList);
        }
        if (context.get("input") != null) {
            context.put("input", context.get("input"));
        }
    }

    public void multiadd(Map<String, Object> context) {
        List serviceList = Tool.sortSimpleName((List)this.providerService.findServices());
        context.put("serviceList", serviceList);
    }

    public boolean create(Map<String, Object> context) throws Exception {
        String line;
        String line2;
        String addr = (String)context.get("address");
        String services = (String)context.get("multiservice");
        if (services == null || services.trim().length() == 0) {
            services = (String)context.get("service");
        }
        String weight = (String)context.get("weight");
        int w = Integer.parseInt(weight);
        HashSet<String> addresses = new HashSet<String>();
        BufferedReader reader = new BufferedReader(new StringReader(addr));
        while (null != (line2 = reader.readLine())) {
            String[] split;
            for (String s : split = line2.split("[\\s,;]+")) {
                if (s.length() == 0) continue;
                String ip = s;
                String port = null;
                if (s.indexOf(":") != -1) {
                    ip = s.substring(0, s.indexOf(":"));
                    port = s.substring(s.indexOf(":") + 1, s.length());
                    if (port.trim().length() == 0) {
                        port = null;
                    }
                }
                if (!IP_PATTERN.matcher(ip).matches()) {
                    context.put("message", "illegal IP: " + s);
                    return false;
                }
                if (LOCAL_IP_PATTERN.matcher(ip).matches() || ALL_IP_PATTERN.matcher(ip).matches()) {
                    context.put("message", "local IP or any host ip is illegal: " + s);
                    return false;
                }
                if (port != null && !NumberUtils.isDigits((String)port)) {
                    context.put("message", "illegal port: " + s);
                    return false;
                }
                addresses.add(s);
            }
        }
        HashSet<String> aimServices = new HashSet<String>();
        reader = new BufferedReader(new StringReader(services));
        while (null != (line = reader.readLine())) {
            String[] split;
            for (String s : split = line.split("[\\s,;]+")) {
                if (s.length() == 0) continue;
                if (!this.currentUser.hasServicePrivilege(s)) {
                    context.put("message", this.getMessage("HaveNoServicePrivilege", new Object[]{s}));
                    return false;
                }
                aimServices.add(s);
            }
        }
        for (String aimService : aimServices) {
            for (String a : addresses) {
                Weight wt = new Weight();
                wt.setUsername((String)context.get("operator"));
                wt.setAddress(Tool.getIP((String)a));
                wt.setService(aimService);
                wt.setWeight(w);
                this.overrideService.saveOverride(OverrideUtils.weightToOverride((Weight)wt));
            }
        }
        return true;
    }

    public void edit(Long id, Map<String, Object> context) {
        this.add(context);
        this.show(id, context);
        context.put("service", this.overrideService.findById(id).getService());
    }

    public void sameSeviceEdit(Long id, Map<String, Object> context) {
        this.add(context);
        this.show(id, context);
    }

    public void show(Long id, Map<String, Object> context) {
        Weight weight = OverrideUtils.overrideToWeight((Override)this.overrideService.findById(id));
        context.put("weight", weight);
    }

    public boolean update(Weight weight, Map<String, Object> context) {
        if (!this.currentUser.hasServicePrivilege(weight.getService())) {
            context.put("message", this.getMessage("HaveNoServicePrivilege", new Object[]{weight.getService()}));
            return false;
        }
        weight.setAddress(Tool.getIP((String)weight.getAddress()));
        this.overrideService.updateOverride(OverrideUtils.weightToOverride((Weight)weight));
        return true;
    }

    public boolean delete(Long[] ids, Map<String, Object> context) {
        for (Long id : ids) {
            Weight w = OverrideUtils.overrideToWeight((Override)this.overrideService.findById(id));
            if (this.currentUser.hasServicePrivilege(w.getService())) continue;
            context.put("message", this.getMessage("HaveNoServicePrivilege", new Object[]{w.getService()}));
            return false;
        }
        for (Long id : ids) {
            this.overrideService.deleteOverride(id);
        }
        return true;
    }
}

