/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.governance.web.governance.module.screen;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.dubbo.governance.service.ConsumerService;
import com.alibaba.dubbo.governance.service.OwnerService;
import com.alibaba.dubbo.governance.service.ProviderService;
import com.alibaba.dubbo.governance.service.RouteService;
import com.alibaba.dubbo.governance.web.common.module.screen.Restful;
import com.alibaba.dubbo.registry.common.domain.Consumer;
import com.alibaba.dubbo.registry.common.domain.Provider;
import com.alibaba.dubbo.registry.common.domain.Route;
import com.alibaba.dubbo.registry.common.route.ParseUtils;
import com.alibaba.dubbo.registry.common.route.RouteRule;
import com.alibaba.dubbo.registry.common.route.RouteUtils;
import com.alibaba.dubbo.registry.common.util.Tool;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class Routes
extends Restful {
    private static final int MAX_RULE_LENGTH = 1000;
    static String[][] when_names = new String[][]{{"method", "method", "unmethod"}, {"consumer.application", "consumerApplication", "unconsumerApplication"}, {"consumer.cluster", "consumerCluster", "unconsumerCluster"}, {"consumer.host", "consumerHost", "unconsumerHost"}, {"consumer.version", "consumerVersion", "unconsumerVersion"}, {"consumer.group", "consumerGroup", "unconsumerGroup"}};
    static String[][] then_names = new String[][]{{"provider.application", "providerApplication", "unproviderApplication"}, {"provider.cluster", "providerCluster", "unproviderCluster"}, {"provider.host", "providerHost", "unproviderHost"}, {"provider.protocol", "providerProtocol", "unproviderProtocol"}, {"provider.port", "providerPort", "unproviderPort"}, {"provider.version", "providerVersion", "unproviderVersion"}, {"provider.group", "providerGroup", "unproviderGroup"}};
    @Autowired
    private RouteService routeService;
    @Autowired
    private ProviderService providerService;
    @Autowired
    private ConsumerService consumerService;

    static void checkService(String service) {
        int vi;
        if (service.contains(",")) {
            throw new IllegalStateException("service(" + service + ") contain illegale ','");
        }
        String interfaceName = service;
        int gi = interfaceName.indexOf("/");
        if (gi != -1) {
            interfaceName = interfaceName.substring(gi + 1);
        }
        if ((vi = interfaceName.indexOf(58)) != -1) {
            interfaceName = interfaceName.substring(0, vi);
        }
        if (interfaceName.indexOf(42) != -1 && interfaceName.indexOf(42) != interfaceName.length() - 1) {
            throw new IllegalStateException("service(" + service + ") only allow 1 *, and must be last char!");
        }
    }

    public static void addOwnersOfService(Set<String> usernames, String serviceName, OwnerService ownerDAO) {
        List serviceNamePatterns = ownerDAO.findAllServiceNames();
        for (String p : serviceNamePatterns) {
            if (!ParseUtils.isMatchGlobPattern((String)p, (String)serviceName)) continue;
            List list = ownerDAO.findUsernamesByServiceName(p);
            usernames.addAll(list);
        }
    }

    public static void addOwnersOfServicePattern(Set<String> usernames, String serviceNamePattern, OwnerService ownerDAO) {
        List serviceNamePatterns = ownerDAO.findAllServiceNames();
        for (String p : serviceNamePatterns) {
            if (!ParseUtils.hasIntersection((String)p, (String)serviceNamePattern)) continue;
            List list = ownerDAO.findUsernamesByServiceName(p);
            usernames.addAll(list);
        }
    }

    public void index(Map<String, Object> context) {
        String service = (String)context.get("service");
        String address = (String)context.get("address");
        address = Tool.getIP((String)address);
        List routes = service != null && service.length() > 0 && address != null && address.length() > 0 ? this.routeService.findByServiceAndAddress(service, address) : (service != null && service.length() > 0 ? this.routeService.findByService(service) : (address != null && address.length() > 0 ? this.routeService.findByAddress(address) : this.routeService.findAll()));
        context.put("routes", routes);
    }

    public void show(Map<String, Object> context) {
        try {
            Route route = this.routeService.findRoute(Long.valueOf(Long.parseLong((String)context.get("id"))));
            if (route == null) {
                throw new IllegalArgumentException("The route is not existed.");
            }
            if (route.getService() != null && !route.getService().isEmpty()) {
                context.put("service", route.getService());
            }
            RouteRule routeRule = RouteRule.parse((Route)route);
            Map[] paramArray = new Map[]{routeRule.getWhenCondition(), routeRule.getThenCondition()};
            String[][][] namesArray = new String[][][]{when_names, then_names};
            for (int i = 0; i < paramArray.length; ++i) {
                String[][] names;
                Map param = paramArray[i];
                for (String[] name : names = namesArray[i]) {
                    RouteRule.MatchPair matchPair = (RouteRule.MatchPair)param.get(name[0]);
                    if (matchPair == null) continue;
                    if (!matchPair.getMatches().isEmpty()) {
                        String m = RouteRule.join((Set)matchPair.getMatches());
                        context.put(name[1], m);
                    }
                    if (matchPair.getUnmatches().isEmpty()) continue;
                    String u = RouteRule.join((Set)matchPair.getUnmatches());
                    context.put(name[2], u);
                }
            }
            context.put("route", route);
            context.put("methods", CollectionUtils.sort(new ArrayList(this.providerService.findMethodsByService(route.getService()))));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public void add(Map<String, Object> context) {
        String service = (String)context.get("service");
        if (service != null && service.length() > 0 && !service.contains("*")) {
            context.put("service", service);
            context.put("methods", CollectionUtils.sort(new ArrayList(this.providerService.findMethodsByService(service))));
        } else {
            List serviceList = Tool.sortSimpleName(new ArrayList(this.providerService.findServices()));
            context.put("serviceList", serviceList);
        }
        if (context.get("input") != null) {
            context.put("input", context.get("input"));
        }
    }

    public void edit(Map<String, Object> context) {
        this.add(context);
        this.show(context);
    }

    public boolean create(Map<String, Object> context) {
        String name = (String)context.get("name");
        String service = (String)context.get("service");
        if (StringUtils.isNotEmpty((String)service) && StringUtils.isNotEmpty((String)name)) {
            Routes.checkService((String)service);
            HashMap<String, String> when_name2valueList = new HashMap<String, String>();
            HashMap<String, String> notWhen_name2valueList = new HashMap<String, String>();
            for (String[] names : when_names) {
                when_name2valueList.put(names[0], (String)context.get(names[1]));
                notWhen_name2valueList.put(names[0], (String)context.get(names[2]));
            }
            HashMap<String, String> then_name2valueList = new HashMap<String, String>();
            HashMap<String, String> notThen_name2valueList = new HashMap<String, String>();
            for (String[] names : then_names) {
                then_name2valueList.put(names[0], (String)context.get(names[1]));
                notThen_name2valueList.put(names[0], (String)context.get(names[2]));
            }
            RouteRule routeRule = RouteRule.createFromNameAndValueListString(when_name2valueList, notWhen_name2valueList, then_name2valueList, notThen_name2valueList);
            if (routeRule.getThenCondition().isEmpty()) {
                context.put("message", this.getMessage("Add route error! then is empty.", new Object[0]));
                return false;
            }
            String matchRule = routeRule.getWhenConditionString();
            String filterRule = routeRule.getThenConditionString();
            if (matchRule.length() > 1000) {
                context.put("message", this.getMessage("When rule is too long!", new Object[0]));
                return false;
            }
            if (filterRule.length() > 1000) {
                context.put("message", this.getMessage("Then rule is too long!", new Object[0]));
                return false;
            }
            Route route = new Route();
            route.setService(service);
            route.setName(name);
            route.setUsername((String)context.get("operator"));
            route.setOperator((String)context.get("operatorAddress"));
            route.setRule(routeRule.toString());
            if (StringUtils.isNotEmpty((String)((String)context.get("priority")))) {
                route.setPriority(Integer.parseInt((String)context.get("priority")));
            }
            this.routeService.createRoute(route);
        }
        return true;
    }

    public boolean update(Map<String, Object> context) {
        String idStr = (String)context.get("id");
        if (idStr != null && idStr.length() > 0) {
            Route oldRoute;
            String[] blacks = (String[])context.get("black");
            boolean black = false;
            if (blacks != null && blacks.length > 0) {
                black = true;
            }
            if (null == (oldRoute = this.routeService.findRoute(Long.valueOf(idStr)))) {
                context.put("message", this.getMessage("NoSuchRecord", new Object[0]));
                return false;
            }
            if (StringUtils.isNotEmpty((String)((String)context.get("name")))) {
                String service = oldRoute.getService();
                if (context.get("operator") == null) {
                    context.put("message", this.getMessage("HaveNoServicePrivilege", new Object[]{service}));
                    return false;
                }
                HashMap<String, String> when_name2valueList = new HashMap<String, String>();
                HashMap<String, String> notWhen_name2valueList = new HashMap<String, String>();
                for (String[] names : when_names) {
                    when_name2valueList.put(names[0], (String)context.get(names[1]));
                    notWhen_name2valueList.put(names[0], (String)context.get(names[2]));
                }
                HashMap<String, String> then_name2valueList = new HashMap<String, String>();
                HashMap<String, String> notThen_name2valueList = new HashMap<String, String>();
                for (String[] names : then_names) {
                    then_name2valueList.put(names[0], (String)context.get(names[1]));
                    notThen_name2valueList.put(names[0], (String)context.get(names[2]));
                }
                RouteRule routeRule = RouteRule.createFromNameAndValueListString(when_name2valueList, notWhen_name2valueList, then_name2valueList, notThen_name2valueList);
                RouteRule result = null;
                if (black) {
                    RouteRule.MatchPair matchPair = (RouteRule.MatchPair)routeRule.getThenCondition().get("black");
                    HashMap<String, RouteRule.MatchPair> then = null;
                    if (null == matchPair) {
                        matchPair = new RouteRule.MatchPair();
                        then = new HashMap<String, RouteRule.MatchPair>();
                        then.put("black", matchPair);
                    } else {
                        matchPair.getMatches().clear();
                    }
                    matchPair.getMatches().add(String.valueOf(black));
                    result = RouteRule.copyWithReplace((RouteRule)routeRule, null, then);
                }
                if (result == null) {
                    result = routeRule;
                }
                if (result.getThenCondition().isEmpty()) {
                    context.put("message", this.getMessage("Update route error! then is empty.", new Object[0]));
                    return false;
                }
                String matchRule = result.getWhenConditionString();
                String filterRule = result.getThenConditionString();
                if (matchRule.length() > 1000) {
                    context.put("message", this.getMessage("When rule is too long!", new Object[0]));
                    return false;
                }
                if (filterRule.length() > 1000) {
                    context.put("message", this.getMessage("Then rule is too long!", new Object[0]));
                    return false;
                }
                int priority = 0;
                if (StringUtils.isNotEmpty((String)((String)context.get("priority")))) {
                    priority = Integer.parseInt((String)context.get("priority"));
                }
                Route route = new Route();
                route.setRule(result.toString());
                route.setService(service);
                route.setPriority(priority);
                route.setName((String)context.get("name"));
                route.setUsername((String)context.get("operator"));
                route.setOperator((String)context.get("operatorAddress"));
                route.setId(Long.valueOf(idStr));
                route.setPriority(Integer.parseInt((String)context.get("priority")));
                route.setEnabled(oldRoute.isEnabled());
                this.routeService.updateRoute(route);
                HashSet<String> usernames = new HashSet<String>();
                usernames.add((String)context.get("operator"));
                usernames.add(route.getUsername());
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("action", "update");
                params.put("route", (String)route);
            } else {
                context.put("message", this.getMessage("MissRequestParameters", new Object[]{"name"}));
            }
        } else {
            context.put("message", this.getMessage("MissRequestParameters", new Object[]{"id"}));
        }
        return true;
    }

    public boolean delete(Long[] ids, Map<String, Object> context) {
        for (Long id : ids) {
            this.routeService.deleteRoute(id);
        }
        return true;
    }

    public boolean enable(Long[] ids, Map<String, Object> context) {
        for (Long id : ids) {
            this.routeService.enableRoute(id);
        }
        return true;
    }

    public boolean disable(Long[] ids, Map<String, Object> context) {
        for (Long id : ids) {
            this.routeService.disableRoute(id);
        }
        return true;
    }

    public void routeselect(Map<String, Object> context) {
        long rid = Long.valueOf((String)context.get("id"));
        context.put("id", rid);
        Route route = this.routeService.findRoute(Long.valueOf(rid));
        if (route == null) {
            throw new IllegalStateException("Route(id=" + rid + ") is not existed!");
        }
        context.put("route", route);
        List consumers = this.consumerService.findByService(route.getService());
        context.put("consumers", consumers);
        HashMap<String, Boolean> matchRoute = new HashMap<String, Boolean>();
        for (Consumer c : consumers) {
            matchRoute.put(c.getAddress(), RouteUtils.matchRoute((String)c.getAddress(), null, (Route)route, null));
        }
        context.put("matchRoute", matchRoute);
    }

    public void preview(Map<String, Object> context) throws Exception {
        List providers;
        String rid = (String)context.get("id");
        String consumerid = (String)context.get("cid");
        if (StringUtils.isEmpty((String)rid)) {
            context.put("message", this.getMessage("MissRequestParameters", new Object[]{"id"}));
        }
        HashMap<String, String> serviceUrls = new HashMap<String, String>();
        Route route = this.routeService.findRoute(Long.valueOf(rid));
        if (null == route) {
            context.put("message", this.getMessage("NoSuchRecord", new Object[0]));
        }
        if ((providers = this.providerService.findByService(route.getService())) != null) {
            for (Provider p : providers) {
                serviceUrls.put(p.getUrl(), p.getParameters());
            }
        }
        if (StringUtils.isNotEmpty((String)consumerid)) {
            Consumer consumer = this.consumerService.findConsumer(Long.valueOf(consumerid));
            if (null == consumer) {
                context.put("message", this.getMessage("NoSuchRecord", new Object[0]));
            }
            Map result = RouteUtils.previewRoute((String)consumer.getService(), (String)consumer.getAddress(), (String)consumer.getParameters(), serviceUrls, (Route)route, null, null);
            context.put("route", route);
            context.put("consumer", consumer);
            context.put("result", result);
        } else {
            String address = (String)context.get("address");
            String service = (String)context.get("service");
            Map result = RouteUtils.previewRoute((String)service, (String)address, null, serviceUrls, (Route)route, null, null);
            context.put("route", route);
            Consumer consumer = new Consumer();
            consumer.setService(service);
            consumer.setAddress(address);
            context.put("consumer", consumer);
            context.put("result", result);
        }
    }
}

