/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.governance.web.governance.module.screen;

import com.alibaba.dubbo.governance.service.OwnerService;
import com.alibaba.dubbo.governance.service.ProviderService;
import com.alibaba.dubbo.governance.web.common.module.screen.Restful;
import com.alibaba.dubbo.registry.common.domain.Owner;
import com.alibaba.dubbo.registry.common.util.Tool;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Owners
extends Restful {
    @Autowired
    private OwnerService ownerService;
    @Autowired
    private ProviderService providerService;

    public void index(Map<String, Object> context) {
        String service = (String)context.get("service");
        List owners = service != null && service.length() > 0 ? this.ownerService.findByService(service) : this.ownerService.findAll();
        context.put("owners", owners);
    }

    public void add(Map<String, Object> context) {
        String service = (String)context.get("service");
        if (service == null || service.length() == 0) {
            List serviceList = Tool.sortSimpleName(new ArrayList(this.providerService.findServices()));
            context.put("serviceList", serviceList);
        }
    }

    public boolean create(Owner owner, Map<String, Object> context) {
        String service = owner.getService();
        String username = owner.getUsername();
        if (service == null || service.length() == 0 || username == null || username.length() == 0) {
            context.put("message", this.getMessage("NoSuchOperationData", new Object[0]));
            return false;
        }
        if (!this.currentUser.hasServicePrivilege(service)) {
            context.put("message", this.getMessage("HaveNoServicePrivilege", new Object[]{service}));
            return false;
        }
        this.ownerService.saveOwner(owner);
        return true;
    }

    public boolean delete(Long[] ids, Map<String, Object> context) {
        String service = (String)context.get("service");
        String username = (String)context.get("username");
        Owner owner = new Owner();
        owner.setService(service);
        owner.setUsername(username);
        if (service == null || service.length() == 0 || username == null || username.length() == 0) {
            context.put("message", this.getMessage("NoSuchOperationData", new Object[0]));
            return false;
        }
        if (!this.currentUser.hasServicePrivilege(service)) {
            context.put("message", this.getMessage("HaveNoServicePrivilege", new Object[]{service}));
            return false;
        }
        this.ownerService.deleteOwner(owner);
        return true;
    }
}

