/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.governance.web.governance.module.screen;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.dubbo.governance.service.ConsumerService;
import com.alibaba.dubbo.governance.service.OverrideService;
import com.alibaba.dubbo.governance.service.ProviderService;
import com.alibaba.dubbo.governance.web.common.module.screen.Restful;
import com.alibaba.dubbo.registry.common.domain.Override;
import com.alibaba.dubbo.registry.common.route.OverrideUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Applications
extends Restful {
    @Autowired
    private ProviderService providerService;
    @Autowired
    private ConsumerService consumerService;
    @Autowired
    private OverrideService overrideService;

    public void index(Map<String, Object> context) {
        List consumerApplications;
        String service = (String)context.get("service");
        if (context.get("service") != null) {
            List consumerApplications2;
            TreeSet applications = new TreeSet();
            List providerApplications = this.providerService.findApplicationsByServiceName(service);
            if (providerApplications != null && providerApplications.size() > 0) {
                applications.addAll(providerApplications);
            }
            if ((consumerApplications2 = this.consumerService.findApplicationsByServiceName(service)) != null && consumerApplications2.size() > 0) {
                applications.addAll(consumerApplications2);
            }
            context.put("applications", applications);
            context.put("providerApplications", providerApplications);
            context.put("consumerApplications", consumerApplications2);
            if (service != null && service.length() > 0) {
                List overrides = this.overrideService.findByService(service);
                HashMap application2Overrides = new HashMap();
                if (overrides != null && overrides.size() > 0 && applications != null && applications.size() > 0) {
                    for (String a : applications) {
                        if (overrides == null || overrides.size() <= 0) continue;
                        ArrayList<Override> appOverrides = new ArrayList<Override>();
                        for (Override override : overrides) {
                            if (!override.isMatch(service, null, a)) continue;
                            appOverrides.add(override);
                        }
                        Collections.sort(appOverrides, OverrideUtils.OVERRIDE_COMPARATOR);
                        application2Overrides.put(a, appOverrides);
                    }
                }
                context.put("overrides", application2Overrides);
            }
            return;
        }
        if (context.get("service") == null && context.get("application") == null && context.get("address") == null) {
            context.put("application", "*");
        }
        TreeSet applications = new TreeSet();
        List providerApplications = this.providerService.findApplications();
        if (providerApplications != null && providerApplications.size() > 0) {
            applications.addAll(providerApplications);
        }
        if ((consumerApplications = this.consumerService.findApplications()) != null && consumerApplications.size() > 0) {
            applications.addAll(consumerApplications);
        }
        HashSet<String> newList = new HashSet<String>();
        HashSet<String> newProviders = new HashSet<String>();
        HashSet<String> newConsumers = new HashSet<String>();
        context.put("applications", applications);
        context.put("providerApplications", providerApplications);
        context.put("consumerApplications", consumerApplications);
        String keyword = (String)context.get("keyword");
        if (StringUtils.isNotEmpty((String)keyword) && !"*".equals(keyword)) {
            keyword = keyword.toLowerCase();
            for (String o : applications) {
                if (o.toLowerCase().indexOf(keyword) == -1) continue;
                newList.add(o);
            }
            for (String o : providerApplications) {
                if (o.toLowerCase().indexOf(keyword) == -1) continue;
                newProviders.add(o);
            }
            for (String o : consumerApplications) {
                if (o.toLowerCase().indexOf(keyword) == -1) continue;
                newConsumers.add(o);
            }
            context.put("applications", newList);
            context.put("providerApplications", newProviders);
            context.put("consumerApplications", newConsumers);
        }
    }

    public void search(Map<String, Object> context) {
        this.index(context);
        HashSet<String> newList = new HashSet<String>();
        Set apps = (Set)context.get("applications");
        String keyword = (String)context.get("keyword");
        if (StringUtils.isNotEmpty((String)keyword)) {
            keyword = keyword.toLowerCase();
            for (String o : apps) {
                if (o.toLowerCase().indexOf(keyword) == -1) continue;
                newList.add(o);
            }
        }
        context.put("applications", newList);
    }

    public boolean shield(Map<String, Object> context) throws Exception {
        return this.mock(context, "force:return null");
    }

    public boolean tolerant(Map<String, Object> context) throws Exception {
        return this.mock(context, "fail:return null");
    }

    public boolean recover(Map<String, Object> context) throws Exception {
        return this.mock(context, "");
    }

    private boolean mock(Map<String, Object> context, String mock) throws Exception {
        String service = (String)context.get("service");
        String applications = (String)context.get("application");
        if (service == null || service.length() == 0 || applications == null || applications.length() == 0) {
            context.put("message", this.getMessage("NoSuchOperationData", new Object[0]));
            return false;
        }
        if (!this.currentUser.hasServicePrivilege(service)) {
            context.put("message", this.getMessage("HaveNoServicePrivilege", new Object[]{service}));
            return false;
        }
        for (String application : SPACE_SPLIT_PATTERN.split(applications)) {
            List overrides = this.overrideService.findByServiceAndApplication(service, application);
            if (overrides != null && overrides.size() > 0) {
                for (Override override : overrides) {
                    Map map = StringUtils.parseQueryString((String)override.getParams());
                    if (mock == null || mock.length() == 0) {
                        map.remove("mock");
                    } else {
                        map.put("mock", URL.encode((String)mock));
                    }
                    if (map.size() > 0) {
                        override.setParams(StringUtils.toQueryString((Map)map));
                        override.setEnabled(true);
                        override.setOperator(this.operator);
                        override.setOperatorAddress(this.operatorAddress);
                        this.overrideService.updateOverride(override);
                        continue;
                    }
                    this.overrideService.deleteOverride(override.getId());
                }
                continue;
            }
            if (mock == null || mock.length() <= 0) continue;
            Override override = new Override();
            override.setService(service);
            override.setApplication(application);
            override.setParams("mock=" + URL.encode((String)mock));
            override.setEnabled(true);
            override.setOperator(this.operator);
            override.setOperatorAddress(this.operatorAddress);
            this.overrideService.saveOverride(override);
        }
        return true;
    }

    public boolean allshield(Map<String, Object> context) throws Exception {
        return this.allmock(context, "force:return null");
    }

    public boolean alltolerant(Map<String, Object> context) throws Exception {
        return this.allmock(context, "fail:return null");
    }

    public boolean allrecover(Map<String, Object> context) throws Exception {
        return this.allmock(context, "");
    }

    private boolean allmock(Map<String, Object> context, String mock) throws Exception {
        String service = (String)context.get("service");
        if (service == null || service.length() == 0) {
            context.put("message", this.getMessage("NoSuchOperationData", new Object[0]));
            return false;
        }
        if (!this.currentUser.hasServicePrivilege(service)) {
            context.put("message", this.getMessage("HaveNoServicePrivilege", new Object[]{service}));
            return false;
        }
        List overrides = this.overrideService.findByService(service);
        Override allOverride = null;
        if (overrides != null && overrides.size() > 0) {
            for (Override override : overrides) {
                if (!override.isDefault()) continue;
                allOverride = override;
                break;
            }
        }
        if (allOverride != null) {
            Map map = StringUtils.parseQueryString((String)allOverride.getParams());
            if (mock == null || mock.length() == 0) {
                map.remove("mock");
            } else {
                map.put("mock", URL.encode((String)mock));
            }
            if (map.size() > 0) {
                allOverride.setParams(StringUtils.toQueryString((Map)map));
                allOverride.setEnabled(true);
                allOverride.setOperator(this.operator);
                allOverride.setOperatorAddress(this.operatorAddress);
                this.overrideService.updateOverride(allOverride);
            } else {
                this.overrideService.deleteOverride(allOverride.getId());
            }
        } else if (mock != null && mock.length() > 0) {
            Override override = new Override();
            override.setService(service);
            override.setParams("mock=" + URL.encode((String)mock));
            override.setEnabled(true);
            override.setOperator(this.operator);
            override.setOperatorAddress(this.operatorAddress);
            this.overrideService.saveOverride(override);
        }
        return true;
    }
}

