/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.governance.web.common.resolver;

import com.alibaba.citrus.turbine.Context;
import com.alibaba.citrus.turbine.TurbineRunDataInternal;
import com.alibaba.dubbo.governance.web.common.resolver.ParameterMap;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterMap
implements Map<String, Object> {
    private static final String CONTEXT_PREFIX = "context.";
    private static final String PARAMETER_PREFIX = "parameter.";
    private static final String HEADER_PREFIX = "header.";
    private static final String REQUEST_PREFIX = "request.";
    private static final String SESSION_PREFIX = "session.";
    private static final String COOKIE_PREFIX = "cookie.";
    private static final String APPLICATION_PREFIX = "application.";
    private static final String RUNDATA_PREFIX = "rundata.";
    private static final String METHOD_KEY = "request.method";
    private static final String REMOTE_HOST_KEY = "request.remoteHost";
    private static final String CONTEXT_PATH_KEY = "request.contextPath";
    private static final String USER_PRINCIPAL_KEY = "request.userPrincipal";
    private static final String TARGET_KEY = "rundata.target";
    private static final String FORWARD_KEY = "rundata.forward";
    private static final String BACKWARD_KEY = "rundata.backward";
    private static final String REDIRECT_KEY = "rundata.redirect";
    private static final String REDIRECTED_KEY = "rundata.redirected";
    private static final String LAYOUT_KEY = "rundata.layout";
    private static final String LAYOUT_ENABLED_KEY = "rundata.layoutEnabled";
    private final HttpServletRequest request;
    private final Context context;
    private final TurbineRunDataInternal rundata;

    public ParameterMap(HttpServletRequest request, Context context, TurbineRunDataInternal navigator) {
        this.request = request;
        this.context = context;
        this.rundata = navigator;
        Enumeration keys = request.getParameterNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Object value = this.getParameterValue(key);
            context.put(key, value);
        }
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            return false;
        }
        Set keys = this.context.keySet();
        if (keys != null && keys.size() > 0) {
            for (String key : keys) {
                if (!value.equals(this.context.get(key))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        String k = (String)key;
        if (k == null || k.length() == 0) {
            return false;
        }
        return this.context.containsKey(k) || this.request.getParameter(k) != null;
    }

    @Override
    public Object get(Object key) {
        String k = (String)key;
        if (k == null || k.length() == 0) {
            return null;
        }
        if (METHOD_KEY.equals(k)) {
            return this.request.getMethod();
        }
        if (REMOTE_HOST_KEY.equals(k)) {
            return this.request.getRemoteHost();
        }
        if (CONTEXT_PATH_KEY.equals(k)) {
            return this.request.getContextPath();
        }
        if (USER_PRINCIPAL_KEY.equals(k)) {
            return this.request.getUserPrincipal();
        }
        if (TARGET_KEY.equals(k)) {
            return this.rundata.getTarget();
        }
        if (FORWARD_KEY.equals(k)) {
            return this.rundata.getRedirectTarget();
        }
        if (REDIRECT_KEY.equals(k)) {
            return this.rundata.getRedirectLocation();
        }
        if (REDIRECTED_KEY.equals(k)) {
            return this.rundata.isRedirected();
        }
        if (LAYOUT_KEY.equals(k)) {
            return this.rundata.getLayoutTemplateOverride();
        }
        if (LAYOUT_ENABLED_KEY.equals(k)) {
            return this.rundata.isLayoutEnabled();
        }
        if (k.startsWith(CONTEXT_PREFIX)) {
            return this.context.get(k.substring(CONTEXT_PREFIX.length()));
        }
        if (k.startsWith(PARAMETER_PREFIX)) {
            return this.getParameterValue(k.substring(PARAMETER_PREFIX.length()));
        }
        if (k.startsWith(HEADER_PREFIX)) {
            return this.request.getHeader(k.substring(HEADER_PREFIX.length()));
        }
        if (k.startsWith(REQUEST_PREFIX)) {
            return this.request.getAttribute(k.substring(REQUEST_PREFIX.length()));
        }
        if (k.startsWith(SESSION_PREFIX)) {
            return this.request.getSession().getAttribute(k.substring(SESSION_PREFIX.length()));
        }
        if (k.startsWith(COOKIE_PREFIX)) {
            return this.getCookieValue(k.substring(COOKIE_PREFIX.length()));
        }
        if (k.startsWith(APPLICATION_PREFIX)) {
            return this.request.getSession().getServletContext().getAttribute(k.substring(APPLICATION_PREFIX.length()));
        }
        Object value = this.context.get(k);
        if (value == null && (value = this.getParameterValue(k)) == null && (value = this.request.getAttribute(k)) == null && (value = this.request.getSession().getAttribute(k)) == null && (value = this.getCookieValue(k)) == null) {
            value = this.request.getSession().getServletContext().getAttribute(k);
        }
        return value;
    }

    private Object getParameterValue(String key) {
        String[] values = this.request.getParameterValues(key);
        if (values == null || values.length == 0) {
            return null;
        }
        if (values.length == 1) {
            return values[0];
        }
        return values;
    }

    private Object getCookieValue(String key) {
        Cookie[] cookies = this.request.getCookies();
        if (cookies != null && cookies.length > 0) {
            for (Cookie cookie : cookies) {
                if (!key.equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    @Override
    public Object put(String key, Object value) {
        if (key == null || key.length() == 0) {
            return null;
        }
        if (TARGET_KEY.equals(key)) {
            this.rundata.setTarget((String)value);
            return null;
        }
        if (FORWARD_KEY.equals(key)) {
            this.rundata.setRedirectTarget((String)value);
            return null;
        }
        if (BACKWARD_KEY.equals(key)) {
            this.rundata.setRedirectLocation(this.request.getHeader("Referer"));
            return null;
        }
        if (REDIRECT_KEY.equals(key)) {
            this.rundata.setRedirectLocation((String)value);
            return null;
        }
        if (LAYOUT_KEY.equals(key)) {
            this.rundata.setLayout((String)value);
            return null;
        }
        if (LAYOUT_ENABLED_KEY.equals(key)) {
            this.rundata.setLayoutEnabled(((Boolean)value).booleanValue());
            return null;
        }
        if (key.startsWith(REQUEST_PREFIX)) {
            key = key.substring(APPLICATION_PREFIX.length());
            Object old = this.request.getAttribute(key);
            if (value == null) {
                this.request.removeAttribute(key);
            } else {
                this.request.setAttribute(key, value);
            }
            return old;
        }
        if (key.startsWith(SESSION_PREFIX)) {
            key = key.substring(APPLICATION_PREFIX.length());
            Object old = this.request.getSession().getAttribute(key);
            if (value == null) {
                this.request.getSession().removeAttribute(key);
            } else {
                this.request.getSession().setAttribute(key, value);
            }
            return old;
        }
        if (key.startsWith(COOKIE_PREFIX)) {
            key = key.substring(APPLICATION_PREFIX.length());
            String old = null;
            Cookie[] cookies = this.request.getCookies();
            if (cookies != null && cookies.length > 0) {
                for (Cookie cookie : cookies) {
                    if (!key.equals(cookie.getName())) continue;
                    old = cookie.getValue();
                    if (value == null) {
                        cookie.setMaxAge(-1);
                        break;
                    }
                    cookie.setValue((String)value);
                    break;
                }
            }
            return old;
        }
        if (key.startsWith(APPLICATION_PREFIX)) {
            key = key.substring(APPLICATION_PREFIX.length());
            Object old = this.request.getSession().getServletContext().getAttribute(key);
            if (value == null) {
                this.request.getSession().getServletContext().removeAttribute(key);
            } else {
                this.request.getSession().getServletContext().setAttribute(key, value);
            }
            return old;
        }
        if (key.startsWith(APPLICATION_PREFIX)) {
            key = key.substring(APPLICATION_PREFIX.length());
        }
        Object old = this.context.get(key);
        if (value == null) {
            this.context.remove(key);
        } else {
            this.context.put(key, value);
        }
        return old;
    }

    @Override
    public Object remove(Object key) {
        return this.put((String)key, null);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> map) {
        if (map != null && map.size() > 0) {
            for (Map.Entry<? extends String, ? extends Object> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public void clear() {
        Set keys = this.context.keySet();
        if (keys != null && keys.size() > 0) {
            for (String key : keys) {
                this.context.remove(key);
            }
        }
    }

    @Override
    public Set<String> keySet() {
        return this.context.keySet();
    }

    @Override
    public Collection<Object> values() {
        Set keys = this.context.keySet();
        HashSet<Object> values = new HashSet<Object>();
        if (keys != null && keys.size() > 0) {
            for (String key : keys) {
                values.add(this.context.get(key));
            }
        }
        return values;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        Set keys = this.context.keySet();
        HashSet<Map.Entry<String, Object>> entries = new HashSet<Map.Entry<String, Object>>();
        if (keys != null && keys.size() > 0) {
            for (String key : keys) {
                entries.add((Map.Entry<String, Object>)new ParameterEntry(this, key));
            }
        }
        return entries;
    }
}

