/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.governance.web.common.interceptor;

import com.alibaba.citrus.service.requestcontext.rewrite.RewriteSubstitutionContext;
import com.alibaba.citrus.service.requestcontext.rewrite.RewriteSubstitutionHandler;
import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class RestfuleUrlRewriter
implements RewriteSubstitutionHandler {
    private static final Logger logger = LoggerFactory.getLogger(RestfuleUrlRewriter.class);
    private static final Map<String, String> pl2single;
    private static final Set<String> appParameter;
    private static final String METHOD_KEY = "_method";
    private static final String TYPE_KEY = "_type";
    private static final String ID_KEY = "id";
    private static final String PAGES_KEY = "currentPage";
    private static final String PATH_KEY = "_path";
    private static final Pattern SLASH_PATTERN;
    private static final Pattern NUM_PATTERN;
    private static final Pattern MULTI_NUM_PATTERN;
    private static final Pattern PAGES_SPLIT_PATTERN;
    private static final Pattern PAGES_PATTERN;

    public void postSubstitution(RewriteSubstitutionContext context) {
        String type;
        String oldPath;
        String path = oldPath = context.getPath();
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        HashMap<String, String> param = new HashMap<String, String>();
        if (PAGES_PATTERN.matcher(path).matches()) {
            String[] page_path = PAGES_SPLIT_PATTERN.split(path);
            path = page_path[0];
            param.put(PATH_KEY, page_path[0]);
            param.put(PAGES_KEY, page_path[1]);
        } else {
            param.put(PATH_KEY, path);
        }
        List<String> temp = Arrays.asList(SLASH_PATTERN.split(path));
        if ("status".equals(temp.get(0)) && temp.size() > 1) {
            context.setPath("servicestatus");
            return;
        }
        String[] split = temp.toArray(new String[temp.size()]);
        if (temp.size() > 2 && temp.contains("services")) {
            ArrayList<String> parts = new ArrayList<String>();
            parts.addAll(temp);
            for (int i = 0; i < temp.size(); ++i) {
                if (!"services".equals(temp.get(i)) || i >= temp.size() - 1 || temp.get(i + 1).contains(".") || temp.get(i + 1).matches("\\d+")) continue;
                String group = (String)parts.get(i + 1);
                String service = (String)parts.get(i + 2);
                parts.remove(i + 1);
                parts.set(i + 1, group + "/" + service);
                break;
            }
            split = parts.toArray(new String[parts.size()]);
        }
        int index = split.length;
        if (split.length < 2) {
            return;
        }
        if (split[index - 1].contains(".")) {
            return;
        }
        if (index % 2 == 0) {
            if (MULTI_NUM_PATTERN.matcher(split[index - 2]).matches()) {
                if (index < 4) {
                    return;
                }
                param.put(METHOD_KEY, split[index - 1]);
                param.put(ID_KEY, split[index - 2]);
                type = split[index - 3];
                param.put(TYPE_KEY, type);
                index -= 3;
            } else {
                type = split[index - 1];
                param.put(TYPE_KEY, type);
                --index;
            }
        } else {
            if (index < 3) {
                return;
            }
            if (NUM_PATTERN.matcher(split[index - 1]).matches()) {
                param.put(ID_KEY, split[index - 1]);
            } else {
                param.put(METHOD_KEY, split[index - 1]);
            }
            type = split[index - 2];
            param.put(TYPE_KEY, type);
            index -= 2;
        }
        for (int i = 1; i < index; i += 2) {
            param.put(split[i], split[i + 1]);
        }
        String method = (String)param.get(METHOD_KEY);
        String defaultRedirect = null;
        defaultRedirect = method == null || method.equals("index") ? oldPath : oldPath.split("/" + method)[0];
        String id = (String)param.get(ID_KEY);
        if (id != null) {
            int i = defaultRedirect.lastIndexOf("/");
            defaultRedirect = defaultRedirect.substring(0, i);
        }
        context.getParameters().setString("defaultRedirect", defaultRedirect);
        String module = split[0];
        context.setPath("/" + module + "/" + type + ".htm");
        for (Map.Entry entry : param.entrySet()) {
            String key = (String)entry.getKey();
            if (pl2single.containsKey(key)) {
                key = (String)pl2single.get(key);
            } else if (!appParameter.contains(key)) {
                logger.info("key " + key + " is not pl noun!");
            }
            context.getParameters().setString(key, (String)entry.getValue());
        }
        if (logger.isInfoEnabled()) {
            logger.info("REWRITE restful uri " + oldPath + " to uri " + module + "/" + type + ".htm?" + param);
        }
    }

    static {
        SLASH_PATTERN = Pattern.compile("/+");
        NUM_PATTERN = Pattern.compile("\\d+");
        MULTI_NUM_PATTERN = Pattern.compile("[+\\d]+");
        PAGES_SPLIT_PATTERN = Pattern.compile("/+pages/+");
        PAGES_PATTERN = Pattern.compile(".*/+pages/+\\d+$");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("services", "service");
        map.put("users", "user");
        map.put("addresses", "address");
        map.put("applications", "application");
        map.put("providers", "provider");
        map.put("comsumers", "comsumer");
        pl2single = Collections.unmodifiableMap(map);
        HashSet<String> set = new HashSet<String>();
        set.add(PATH_KEY);
        set.add(PAGES_KEY);
        set.add(METHOD_KEY);
        set.add(TYPE_KEY);
        set.add(ID_KEY);
        appParameter = Collections.unmodifiableSet(set);
    }
}

