/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.governance.web.common.interceptor;

import com.alibaba.citrus.service.pipeline.PipelineContext;
import com.alibaba.citrus.service.pipeline.support.AbstractValve;
import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.dubbo.governance.service.UserService;
import com.alibaba.dubbo.registry.common.domain.User;
import com.alibaba.dubbo.registry.common.util.Coder;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class AuthorizationValve
extends AbstractValve {
    private static final Logger logger = LoggerFactory.getLogger(AuthorizationValve.class);
    private static final String BASIC_CHALLENGE = "Basic";
    private static final String DIGEST_CHALLENGE = "Digest";
    private static final String CHALLENGE = "Basic";
    private static final String REALM = "dubbo";
    private static Pattern PARAMETER_PATTERN = Pattern.compile("(\\w+)=[\"]?([^,\"]+)[\"]?[,]?\\s*");
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private HttpServletResponse response;
    @Autowired
    private UserService userService;
    private String logout = "/logout";
    private String logoutCookie = "logout";

    static Map<String, String> parseParameters(String query) {
        Matcher matcher = PARAMETER_PATTERN.matcher(query);
        HashMap<String, String> map = new HashMap<String, String>();
        while (matcher.find()) {
            String key = matcher.group(1);
            String value = matcher.group(2);
            map.put(key, value);
        }
        return map;
    }

    static byte[] readToBytes(InputStream in) throws IOException {
        byte[] buf = new byte[in.available()];
        in.read(buf);
        return buf;
    }

    protected void init() throws Exception {
    }

    public void invoke(PipelineContext pipelineContext) throws Exception {
        if (logger.isInfoEnabled()) {
            logger.info("AuthorizationValve of uri: " + this.request.getRequestURI());
        }
        String uri = this.request.getRequestURI();
        String contextPath = this.request.getContextPath();
        if (contextPath != null && contextPath.length() > 0 && !"/".equals(contextPath)) {
            uri = uri.substring(contextPath.length());
        }
        if (uri.equals(this.logout)) {
            if (!this.isLogout()) {
                this.setLogout(true);
                this.showLoginForm();
            } else {
                this.setLogout(false);
                this.response.sendRedirect(contextPath == null || contextPath.length() == 0 ? "/" : contextPath);
            }
            return;
        }
        if (!uri.startsWith("/status/")) {
            int i;
            User user = null;
            String authType = null;
            String authorization = this.request.getHeader("Authorization");
            if (authorization != null && authorization.length() > 0 && (i = authorization.indexOf(32)) >= 0) {
                authType = authorization.substring(0, i);
                String authPrincipal = authorization.substring(i + 1);
                if ("Basic".equalsIgnoreCase(authType)) {
                    user = this.loginByBase(authPrincipal);
                } else if ("Digest".equalsIgnoreCase(authType)) {
                    user = this.loginByDigest(authPrincipal);
                }
            }
            if (user == null || user.getUsername() == null || user.getUsername().length() == 0) {
                this.showLoginForm();
                pipelineContext.breakPipeline(1);
            }
            if (user != null && StringUtils.isNotEmpty((String)user.getUsername())) {
                this.request.getSession().setAttribute("currentUser", user);
                pipelineContext.invokeNext();
            }
        } else {
            pipelineContext.invokeNext();
        }
    }

    private User getUser(String username) {
        return this.userService.findUser(username);
    }

    private void showLoginForm() throws IOException {
        if ("Digest".equals("Basic")) {
            this.response.setHeader("WWW-Authenticate", "Basic realm=\"dubbo\", qop=\"auth\", nonce=\"" + UUID.randomUUID().toString().replace("-", "") + "\", opaque=\"" + Coder.encodeMd5((String)"dubbo") + "\"");
        } else {
            this.response.setHeader("WWW-Authenticate", "Basic realm=\"dubbo\"");
        }
        this.response.setHeader("Cache-Control", "must-revalidate,no-cache,no-store");
        this.response.setHeader("Content-Type", "text/html; charset=iso-8859-1");
        this.response.sendError(401);
    }

    private User loginByBase(String authorization) {
        String password;
        int i;
        String username = (authorization = Coder.decodeBase64((String)authorization)).substring(0, i = authorization.indexOf(58));
        if (username != null && username.length() > 0 && (password = authorization.substring(i + 1)) != null && password.length() > 0) {
            String pwd;
            String passwordDigest = Coder.encodeMd5((String)(username + ":" + "dubbo" + ":" + password));
            User user = this.getUser(username);
            if (user != null && (pwd = user.getPassword()) != null && pwd.length() > 0 && passwordDigest.equals(pwd)) {
                return user;
            }
        }
        return null;
    }

    private User loginByDigest(String value) throws IOException {
        String pwd;
        User user;
        String passwordDigest;
        Map params = AuthorizationValve.parseParameters((String)value);
        String username = (String)params.get("username");
        if (username != null && username.length() > 0 && (passwordDigest = (String)params.get("response")) != null && passwordDigest.length() > 0 && (user = this.getUser(username)) != null && (pwd = user.getPassword()) != null && pwd.length() > 0) {
            String digest;
            String uri = (String)params.get("uri");
            String nonce = (String)params.get("nonce");
            String nc = (String)params.get("nc");
            String cnonce = (String)params.get("cnonce");
            String qop = (String)params.get("qop");
            String method = this.request.getMethod();
            String a1 = pwd;
            String a2 = "auth-int".equals(qop) ? Coder.encodeMd5((String)(method + ":" + uri + ":" + Coder.encodeMd5((byte[])AuthorizationValve.readToBytes((InputStream)this.request.getInputStream())))) : Coder.encodeMd5((String)(method + ":" + uri));
            String string = digest = "auth".equals(qop) || "auth-int".equals(qop) ? Coder.encodeMd5((String)(a1 + ":" + nonce + ":" + nc + ":" + cnonce + ":" + qop + ":" + a2)) : Coder.encodeMd5((String)(a1 + ":" + nonce + ":" + a2));
            if (digest.equals(passwordDigest)) {
                return user;
            }
        }
        return null;
    }

    private boolean isLogout() {
        Cookie[] cookies = this.request.getCookies();
        if (cookies != null && cookies.length > 0) {
            for (Cookie cookie : cookies) {
                if (cookie == null || !this.logoutCookie.equals(cookie.getName())) continue;
                return "true".equals(cookie.getValue());
            }
        }
        return false;
    }

    private void setLogout(boolean logoutValue) {
        this.response.addCookie(new Cookie(this.logoutCookie, String.valueOf(logoutValue)));
    }
}

